#!/bin/bash

ACTION=$1
USERNAME=$2
PASSWORD=$3
NEW_PASSWORD=$4

if [ -z "$USERNAME" ]; then
    exit 1
fi

case "$ACTION" in
    add)
        getent passwd "$USERNAME" &>/dev/null
        if [ $? -ne 0 ]; then
            useradd -m "$USERNAME"
            if [ $? -eq 0 ]; then
                echo "$USERNAME:$PASSWORD" | chpasswd
            fi
        fi
        ;;
    modify)
        getent passwd "$USERNAME" &>/dev/null
        if [ $? -eq 0 ]; then
            echo "$USERNAME:$NEW_PASSWORD" | chpasswd
        else
            useradd -m "$USERNAME"
            if [ $? -eq 0 ]; then
                echo "$USERNAME:$NEW_PASSWORD" | chpasswd
            fi
        fi
        ;;
    delete)
        getent passwd "$USERNAME" &>/dev/null
        if [ $? -ne 0 ]; then
            userdel -rf "$USERNAME"
        fi
        ;;
    restart)
        systemctl restart radiusd
        ;;
    *)
        exit 1
        ;;
esac

